var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
import { EMPTY_ARRAY, atom, computed } from "@tldraw/state";
import { isShapeId } from "@tldraw/tlschema";
import { BoundsSnaps } from "./BoundsSnaps.mjs";
import { HandleSnaps } from "./HandleSnaps.mjs";
class SnapManager {
  constructor(editor) {
    this.editor = editor;
    this.shapeBounds = new BoundsSnaps(this);
    this.handles = new HandleSnaps(this);
  }
  shapeBounds;
  handles;
  _snapIndicators = atom("snapLines", void 0);
  getIndicators() {
    return this._snapIndicators.get() ?? EMPTY_ARRAY;
  }
  clearIndicators() {
    if (this.getIndicators().length) {
      this._snapIndicators.set(void 0);
    }
  }
  setIndicators(indicators) {
    this._snapIndicators.set(indicators);
  }
  getSnapThreshold() {
    return 8 / this.editor.getZoomLevel();
  }
  getSnappableShapes() {
    const { editor } = this;
    const renderingBounds = editor.getViewportPageBounds();
    const selectedShapeIds = editor.getSelectedShapeIds();
    const snappableShapes = /* @__PURE__ */ new Set();
    const collectSnappableShapesFromParent = (parentId) => {
      if (isShapeId(parentId)) {
        const parent = editor.getShape(parentId);
        if (parent && editor.isShapeOfType(parent, "frame")) {
          snappableShapes.add(parentId);
        }
      }
      const sortedChildIds = editor.getSortedChildIdsForParent(parentId);
      for (const childId of sortedChildIds) {
        if (selectedShapeIds.includes(childId)) continue;
        const childShape = editor.getShape(childId);
        if (!childShape) continue;
        const util = editor.getShapeUtil(childShape);
        if (!util.canSnap(childShape)) continue;
        const pageBounds = editor.getShapePageBounds(childId);
        if (!(pageBounds && renderingBounds.includes(pageBounds))) continue;
        if (editor.isShapeOfType(childShape, "group")) {
          collectSnappableShapesFromParent(childId);
          continue;
        }
        snappableShapes.add(childId);
      }
    };
    collectSnappableShapesFromParent(this.getCurrentCommonAncestor() ?? editor.getCurrentPageId());
    return snappableShapes;
  }
  getCurrentCommonAncestor() {
    return this.editor.findCommonAncestor(this.editor.getSelectedShapes());
  }
}
__decorateClass([
  computed
], SnapManager.prototype, "getSnapThreshold", 1);
__decorateClass([
  computed
], SnapManager.prototype, "getSnappableShapes", 1);
__decorateClass([
  computed
], SnapManager.prototype, "getCurrentCommonAncestor", 1);
export {
  SnapManager
};
//# sourceMappingURL=SnapManager.mjs.map
